% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getSccsModel}
\alias{getSccsModel}
\title{Extract the SCCS model table}
\usage{
getSccsModel(
  connectionHandler,
  schema,
  sccsTablePrefix = "sccs_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  exposureOutcomeSetIds = NULL,
  indicationIds = NULL,
  outcomeIds = NULL,
  databaseIds = NULL,
  analysisIds = NULL,
  targetIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{exposureOutcomeSetIds}{the exposureOutcomeIds to restrict to}

\item{indicationIds}{The indications that the target was nested to}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{databaseIds}{the database IDs to restrict to}

\item{analysisIds}{the analysis IDs to restrict to}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}
}
\value{
Returns a data.frame with the SCCS model table
}
\description{
This function extracts the sccs model table.
}
\details{
Specify the connectionHandler, the schema and optionally the target/outcome/analysis/database IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsModels <- getSccsModel(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
