% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterizationPlots.R
\name{plotAgeDistributions}
\alias{plotAgeDistributions}
\title{Plots the age distributions using the binary age groups}
\usage{
plotAgeDistributions(
  ageData,
  riskWindowStart = "1",
  riskWindowEnd = "365",
  startAnchor = "cohort start",
  endAnchor = "cohort start"
)
}
\arguments{
\item{ageData}{The age data extracted using 'getCharacterizationDemographics(type = 'age')'}

\item{riskWindowStart}{The time at risk window start}

\item{riskWindowEnd}{The time at risk window end}

\item{startAnchor}{The anchor for the time at risk start}

\item{endAnchor}{The anchor for the time at risk end}
}
\value{
Returns a ggplot with the distributions
}
\description{
Creates bar charts for the target and case age groups.
}
\details{
Input the data returned from 'getCharacterizationDemographics(type = 'age')' and the time-at-risk
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

ageData <- getCharacterizationDemographics(
connectionHandler = connectionHandler, 
schema = 'main',
targetId = 1, 
outcomeId = 3, 
type = 'age'
)

plotAgeDistributions(ageData = ageData)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
