% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationPlots.R
\name{plotSccsEstimates}
\alias{plotSccsEstimates}
\title{Plots the self controlled case series results for one analysis}
\usage{
plotSccsEstimates(sccsData, sccsMeta = NULL, targetName, selectedAnalysisId)
}
\arguments{
\item{sccsData}{The self controlled case series data}

\item{sccsMeta}{(optional) The self controlled case seriesd evidence synthesis data}

\item{targetName}{A friendly name for the target cohort}

\item{selectedAnalysisId}{The analysis ID of interest to plot}
}
\value{
Returns a ggplot with the estimates
}
\description{
Creates nice self controlled case series plots
}
\details{
Input the self controlled case series data
}
\examples{

conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsEst <- getSccsEstimation(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)
plotSccsEstimates(
  sccsData = sccsEst, 
  sccsMeta = NULL, 
  targetName = 'target', 
  selectedAnalysisId = 1
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()}
}
\concept{Estimation}
