% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_spline_surv_model}
\alias{f_plot_spline_surv_model}
\title{Spline Survival Model Overlay}
\usage{
f_plot_spline_surv_model(PERSUADE, model_index = 1)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}

\item{model_index}{Integer. Index of the spline model in \code{PERSUADE$surv_pred$model$spline}.}
}
\value{
A base R plot of KM curves with spline model overlays and knots.
}
\description{
Overlays a spline-based survival model on KM curves, including shaded KM
confidence bands and vertical lines for knot positions.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = TRUE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_spline_surv_model(PERSUADE, model_index = 1)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
