#' Simulated PCL-5 (PTSD Checklist) Data
#'
#' A dataset containing simulated responses from 5,000 patients on the PCL-5
#' (PTSD Checklist for DSM-5). Each patient rated 20 PTSD symptoms on a scale
#' from 0 to 4.
#'
#' @format A data frame with 5,000 rows and 20 columns:
#'
#' \describe{
#'   \item{S1}{Intrusive memories}
#'   \item{S2}{Nightmares}
#'   \item{S3}{Flashbacks}
#'   \item{S4}{Emotional reactivity to reminders}
#'   \item{S5}{Physical reactions to reminders}
#'   \item{S6}{Avoiding memories/thoughts/feelings}
#'   \item{S7}{Avoiding external reminders}
#'   \item{S8}{Amnesia}
#'   \item{S9}{Strong negative beliefs}
#'   \item{S10}{Distorted blame}
#'   \item{S11}{Negative trauma-related emotions}
#'   \item{S12}{Decreased interest in activities}
#'   \item{S13}{Detachment or estrangement}
#'   \item{S14}{Trouble experiencing positive emotions}
#'   \item{S15}{Irritability/aggression}
#'   \item{S16}{Risk-taking behavior}
#'   \item{S17}{Hypervigilance}
#'   \item{S18}{Heightened startle reaction}
#'   \item{S19}{Difficulty concentrating}
#'   \item{S20}{Sleep problems}
#' }
#'
#' @details
#' The symptoms are rated on a 5-point scale:
#'
#' \itemize{
#' \item 0 = Not at all
#' \item 1 = A little bit
#' \item 2 = Moderately
#' \item 3 = Quite a bit
#' \item 4 = Extremely
#'}
#'
#' The symptoms correspond to DSM-5 PTSD criteria:
#'
#' \itemize{
#' \item Symptoms 1-5: Criterion B (Intrusion)
#' \item Symptoms 6-7: Criterion C (Avoidance)
#' \item Symptoms 8-14: Criterion D (Negative alterations in cognitions and mood)
#' \item Symptoms 15-20: Criterion E (Alterations in arousal and reactivity)
#'}
#'
#' @source Simulated data for demonstration purposes
"simulated_ptsd"
