% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyclopsSettings.R
\name{setIterativeHardThresholding}
\alias{setIterativeHardThresholding}
\title{Create setting for Iterative Hard Thresholding model}
\usage{
setIterativeHardThresholding(
  K = 10,
  penalty = "bic",
  seed = sample(1e+05, 1),
  exclude = c(),
  forceIntercept = FALSE,
  fitBestSubset = FALSE,
  initialRidgeVariance = 0.1,
  tolerance = 1e-08,
  maxIterations = 10000,
  threshold = 1e-06,
  delta = 0
)
}
\arguments{
\item{K}{The maximum number of non-zero predictors}

\item{penalty}{Specifies the IHT penalty; possible values are \code{BIC} or \code{AIC} or a numeric value}

\item{seed}{An option to add a seed when training the model}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{forceIntercept}{Logical: Force intercept coefficient into regularization}

\item{fitBestSubset}{Logical: Fit final subset with no regularization}

\item{initialRidgeVariance}{integer}

\item{tolerance}{numeric}

\item{maxIterations}{integer}

\item{threshold}{numeric}

\item{delta}{numeric}
}
\value{
\code{modelSettings} object
}
\description{
Create setting for Iterative Hard Thresholding model
}
\examples{
\dontshow{if (rlang::is_installed("IterativeHardThresholding")) withAutoprint(\{ # examplesIf}
modelIht <- setIterativeHardThresholding(K = 5, seed = 42)
\dontshow{\}) # examplesIf}
}
