% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MP.R
\name{MP}
\alias{MP}
\title{Mean Productivity (MP)}
\usage{
MP(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A data frame with \code{Gen}, \code{MP}.

\deqn{MP = \frac{YN + YS}{2}}
}
\description{
This function computes Mean Productivity (MP) using any traits (like yield) under stress and non-stress conditions. The lower values of MP indicates greater tolerance. For more details see Rosielle and Hamblin (1981) \url{doi:10.2135/cropsci1981.0011183X002100060033x}.
}
\examples{
out = MP(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Rosielle, A.A. and Hamblin, J. (1981). <10.2135/cropsci1981.0011183X002100060033x>.
}
