% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{pdistance}
\alias{pdistance}
\title{Calculate the cell-feature distance matrix}
\usage{
pdistance(object, reduction = "fast", assay.name = "distce", eta = 1e-10)
}
\arguments{
\item{object}{a Seurat object.}

\item{reduction}{a opstional string, dimensional reduction name, `fast` by default.}

\item{assay.name}{a opstional string, specify the new generated assay name, `distce` by default.}

\item{eta}{an optional postive real, a quantity to avoid numerical errors. 1e-10 by default.}
}
\description{
Calculate the cell-feature distance matrix based on coembeddings.
}
\details{
This function calculate the distance matrix between cells/spots and features, and then put the distance matrix in a new generated assay. This 
distance matrix will be used in the siganture gene identification.
}
\examples{
data(pbmc3k_subset)
pbmc3k_subset <- NCFM(pbmc3k_subset)
pbmc3k_subset <- pdistance(pbmc3k_subset, "ncfm")
}
