% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tac.R
\name{tac}
\alias{tac}
\title{Computes a contingency table (tac) of all columns in a dataframe for control purposes}
\usage{
tac(
  df,
  values = NULL,
  sample_rate = 0.01,
  num_but_discrete = "NULL",
  strates = NULL
)
}
\arguments{
\item{df}{Input data.frame}

\item{values}{Vector of columns that serve as measures (amounts, counts, etc.)}

\item{sample_rate}{Sampling rate, if df is a remote table}

\item{num_but_discrete}{Vector of names of numeric columns with discrete modalities (not continuous)}

\item{strates}{Vector of column names by which to stratify the contingency tables}
}
\value{
data.frame
}
\description{
Contingency table (tac) of all columns in a dataframe for control purposes
}
\examples{
tab <- tac(iris) # calculate column frequencies

}
