% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exposure_data}
\alias{exposure_data}
\title{Simulated Data and Parameters for a exposure profile linear mixed model}
\format{
A list with 2 components:
\describe{
\item{df}{A data frame with 4,500 rows and 6 variables (the simulated data).}
\item{theta0}{A list of 11 elements containing the true parameters used for simulation.}
}
}
\source{
Generated synthetically by the package authors.
}
\usage{
exposure_data
}
\description{
A list containing a simulated exposure dataset (\code{df}) and the ground-truth parameters
(\code{theta0}) used to generate it.

The dataset \code{df} contains \eqn{N = 4500} observations across \eqn{n_{Ind} = 1500}
individuals, with $n_R = 3$ repeated measures per individual.
}
\details{
The underlying model for the response \eqn{\bold{Y}} is:
\deqn{\bold{Y} = \bold{X}_{Fe}\bold{\beta} + \bold{X}_{Int}\bold{\alpha}_{Lat} + \bold{X}_{Re}\bold{\alpha}_{RE} + \bold{\epsilon}}
}
\section{\code{df} Data Variables}{

\describe{
\item{X}{Continuous predictor (\eqn{\sim N(0, 1)}).}
\item{t}{Time-like variable (structured around 0, 1, 2).}
\item{indiv}{**Individual ID** (1 to 1500), the grouping factor.}
\item{Exp1, Exp2}{Exposure continuous predictors.}
\item{Y}{The **Simulated Response Variable** calculated as: \eqn{\bold{Y} = y_{Fe} + y_{Int} + y_{Re} + \epsilon}, where \eqn{\epsilon ~ N(0, 1)}.}
}
}

\section{\code{theta0} Parameters}{

The list \code{theta0} holds the true values used to generate \code{Y}, including:
\itemize{
\item \code{Lat}: **Categorical Factor** (9 levels), defining the clusters for interaction effects.
\item \code{beta}: True fixed effects for the global intercept and \eqn{\bold{X}} (i.e., $(3, 2)$).
\item \code{alphaLat}: Vector of 18 coefficients defining the cluster-specific intercepts and slopes for \eqn{\bold{X}} within the 9 \code{Lat} categories.
\item \code{alphaRE}: Vector of 1500 random slopes for the time variable \eqn{\bold{t}}, drawn from $N(0, 1)$.
\item \code{sigma}: Residual standard deviation (1).
}
}

\keyword{datasets}
