% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PxWebApi2.R
\name{meta_code_list}
\alias{meta_code_list}
\title{PxWebApi v2 metadata for a code list}
\usage{
meta_code_list(url, as_frame = TRUE)
}
\arguments{
\item{url}{A PxWebApi v2 URL to metadata for a code list.}

\item{as_frame}{Logical. When TRUE, the metadata is structured as a
data frame, with additional information stored in an attribute named
\code{"extra"}.}
}
\value{
An R object containing metadata for the code list. When \code{as_frame = TRUE},
the result is a data frame.
}
\description{
Retrieves metadata for a code list and returns it as an R object.
}
\examples{
metaframes <- meta_frames(7459, url_type = "ssb_en")
url <- attr(metaframes[["Region"]], "code_lists")[["links"]][3]
print(url)

df <- meta_code_list(url)

print(df)
print(attr(df, "extra")[1:3])

}
