% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_parameter_VAR.R
\name{parameter_VAR}
\alias{parameter_VAR}
\title{Varying parameter object constructor.}
\usage{
parameter_VAR(
  name,
  index,
  d,
  init,
  prior.dist = rep("FlatPrior", length(init)),
  prior.par = rep(list(NULL), length(init))
)
}
\arguments{
\item{name}{character, parameter name.}

\item{index}{character, name of column in VAR.indx (see ?dataset) containing the index for this varying parameter}

\item{d}{dataset object, the dataset containing (amongst other things) the index above}

\item{init}{numeric vector, initial guesses for each instance of the VAR parameter.}

\item{prior.dist}{character vector, prior distribution for each instance of the VAR parameter.}

\item{prior.par}{list of numeric vectors, prior parameters for each instance of the VAR parameter}
}
\value{
An object of class 'parameter_VAR'.
}
\description{
Creates a new instance of a 'parameter_VAR' object
}
\examples{
X=data.frame(input1=rnorm(100),input2=rnorm(100))
Y=data.frame(output=X$input1+0.8*X$input2+0.1*rnorm(100))
VAR.indx=data.frame(indx=c(rep(1,50),rep(2,50)))
workspace=tempdir()
d <- dataset(X=X,Y=Y,data.dir=workspace,VAR.indx=VAR.indx)
p <- parameter_VAR(name='par',index='indx',d=d,
                   init=c(-1,1,2),
                   prior.dist=c('Gaussian','FlatPrior','Triangle'),
                   prior.par=list(c(-1,1),NULL,c(2,0,5)))
}
