% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cfrank}
\alias{cfrank}
\title{Frank copula constructor}
\usage{
cfrank(theta)
}
\arguments{
\item{theta}{Dependence parameter (\eqn{\theta = 0}).}
}
\value{
Function of two arguments (u,v) returning log copula density.
}
\description{
Returns a function computing the log density of the bivariate Frank copula,
intended to be used with \code{\link{dcopula}}.
}
\details{
The Frank copula density is
\deqn{
c(u,v;\theta) = \frac{\theta (1-e^{-\theta}) e^{-\theta(u+v)}}
{\left[(e^{-\theta u}-1)(e^{-\theta v}-1) + (1 - e^{-\theta}) \right]^2}, \quad \theta \ne 0.
}
}
\examples{
x <- c(0.5, 1); y <- c(1, 2)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dexp(y, 2, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pexp(y, 2)
dcopula(d1, d2, p1, p2, copula = cfrank(2), log = TRUE)
}
\seealso{
\code{\link[=cgaussian]{cgaussian()}}, \code{\link[=cclayton]{cclayton()}}, \code{\link[=cgumbel]{cgumbel()}}
}
