% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vm.R
\name{vm}
\alias{vm}
\alias{dvm}
\alias{pvm}
\alias{rvm}
\title{von Mises distribution}
\usage{
dvm(x, mu = 0, kappa = 1, log = FALSE)

pvm(q, mu = 0, kappa = 1, from = NULL, tol = 1e-20)

rvm(n, mu = 0, kappa = 1, wrap = TRUE)
}
\arguments{
\item{x, q}{vector of angles measured in radians at which to evaluate the density function.}

\item{mu}{mean direction of the distribution measured in radians.}

\item{kappa}{non-negative numeric value for the concentration parameter of the distribution.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}

\item{from}{value from which the integration for CDF starts. If \code{NULL}, is set to \code{mu - pi}.}

\item{tol}{the precision in evaluating the distribution function}

\item{n}{number of random values to return.}

\item{wrap}{logical; if \code{TRUE}, generated angles are wrapped to the interval from -pi to pi.}
}
\value{
\code{dvm} gives the density, \code{pvm} gives the distribution function, and \code{rvm} generates random deviates.
}
\description{
Density, distribution function, and random generation for the von Mises distribution.
}
\details{
This implementation of \code{dvm} allows for automatic differentiation with \code{RTMB}.
\code{rvm} and \code{pvm} are simply wrappers of the corresponding functions from \code{circular}.
}
\examples{
set.seed(1)
x <- rvm(10, 0, 1)
d <- dvm(x, 0, 1)
p <- pvm(x, 0, 1)
}
