% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_table.R
\name{prepare_table}
\alias{prepare_table}
\title{Prepare a Data Frame for Summarization with Custom Missing Data Handling and Factor Ordering}
\usage{
prepare_table(
  data1,
  by_group = FALSE,
  var_group = NULL,
  drop_levels = TRUE,
  freq_relevel = FALSE,
  show_missing_data = TRUE
)
}
\arguments{
\item{data1}{A data frame containing the data to be prepared.}

\item{by_group}{A boolean (default is FALSE) to analyse by group.}

\item{var_group}{The group variable (used to correctly update the label if needed).}

\item{drop_levels}{Boolean (default = TRUE). Drop unused levels.}

\item{freq_relevel}{Boolean  (default = FALSE). Reorder factors by frequency except for the group variable.}

\item{show_missing_data}{Should the missing data be displayed. Can be either :
\itemize{
\item \code{FALSE}: No missing data displayed
\item \code{TRUE}(default): Missing data displayed
}}
}
\value{
A data frame that has been prepared based on the \code{show_missing_data} and \code{DM} arguments.
The function modifies the input data frame by applying labels, ordering factor variables,
and potentially dropping unused levels.
}
\description{
This function prepares a data frame for summarization by handling missing data
based on the \code{show_missing_data} argument and applying the specified data manipulation
(DM) option to factor variables. It provides flexibility for data cleaning and ordering
before summarizing with functions like \code{gtsummary}.
}
\details{
\itemize{
\item The \code{DM} option defines the data manipulation to be applied to factor variables:
\itemize{
\item \code{"tout"}: Both order factor levels and drop unused levels.
\item \code{"tri"}: Only order factor levels.
\item \code{"remove"}: Drop unused factor levels without ordering.
}
}
}
\examples{
# Example usage with the iris dataset
prepare_table(iris)

}
