% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppXsimd.R
\name{supportsNEON}
\alias{supportsNEON}
\title{Determine if CPU supports NEON SIMD instructions}
\usage{
supportsNEON()
}
\value{
Boolean
}
\description{
Determine if CPU supports NEON SIMD instructions
}
\examples{
\dontrun{

if (supportsNEON()) {
  Sys.setenv(PKG_CPPFLAGS = getNEONFlags())
  Rcpp::sourceCpp(verbose = TRUE, code='
    // [[Rcpp::plugins(cpp14)]]
    // [[Rcpp::depends(RcppXsimd)]]
               
    #include <Rcpp.h>
    #include "xsimd/xsimd.hpp"
               
    // [[Rcpp::export]] 
    void demoNEON() {
      xsimd::batch<double, 2> a(1.0);
      xsimd::batch<double, 2> b(1.0);
      Rcpp::Rcout << a << " + " << b << " = " << (a + b) << std::endl;
    }')
  demoNEON()
} else {
  message("NEON is not supported")
}
}

}
