% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vamp_functions.R
\name{vampPlugins}
\alias{vampPlugins}
\title{List All Available Vamp Plugins}
\usage{
vampPlugins()
}
\value{
A data frame with one row per plugin and columns including:
\describe{
\item{library}{Plugin library name (without extension)}
\item{name}{Human-readable plugin name}
\item{id}{Unique plugin identifier (library:plugin format)}
\item{plugin.version}{Plugin version number}
\item{vamp.api.version}{Vamp API version the plugin uses}
\item{maker}{Plugin author/creator}
\item{copyright}{Copyright information}
\item{description}{Detailed plugin description}
\item{input.domain}{Input domain: "Time Domain" or "Frequency Domain"}
\item{default.step.size}{Default step size in samples}
\item{default.block.size}{Default block size in samples}
\item{minimum.channels}{Minimum number of audio channels required}
\item{maximum.channels}{Maximum number of audio channels supported}
}
}
\description{
Enumerates all Vamp plugins found in the plugin search paths and returns
detailed information about each plugin including metadata, parameters,
and audio processing requirements.
}
\examples{
\dontrun{
# List all installed plugins
plugins <- vampPlugins()

# Filter for specific library
aubio_plugins <- plugins[plugins$library == "vamp-aubio-plugins", ]
}
}
\seealso{
\code{\link{vampPluginParams}} to get parameter information for a specific plugin
}
