% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_frequentist.R
\name{cusum}
\alias{cusum}
\title{CUSUM Changepoint Detection}
\usage{
cusum(
  data,
  type = "mean",
  threshold = 4,
  mode = "offline",
  mu0 = NULL,
  sigma = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector}

\item{type}{Type of change ("mean", "variance", "both")}

\item{threshold}{Detection threshold (alarm when statistic exceeds this)}

\item{mode}{"offline" for retrospective or "online" for sequential}

\item{mu0}{Target mean under null hypothesis (for online mode)}

\item{sigma}{Known standard deviation (if NULL, estimated from data)}

\item{...}{Additional arguments}
}
\value{
List with changepoints and statistics
}
\description{
Detects changepoints using the Cumulative Sum (CUSUM) statistic.
Foundational method for detecting changes in mean.
}
\examples{
data <- c(rnorm(50), rnorm(50, mean = 2))
result <- cusum(data)

}
