% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustPlot.R
\name{ClustPlot}
\alias{ClustPlot}
\title{Plotting the clustring results}
\usage{
ClustPlot(data, grouping, exact_grouping, centers, k)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{grouping}{List with information of the groups obtained using some clustering method. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to the group i are.}

\item{exact_grouping}{List with the information of the real groups present in the data. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to the group i are.}

\item{centers}{Matrix. Each row contains the center of each group. The groups are obtained using some clustering methods.}

\item{k}{Number. Number of groups.}
}
\value{
Returns a plot where it is possible to visualize the he points, the center of the groups, the exact groups (represented in the type of point used to represent the data) and the obtained groups (observed in the geometric froms that join the points).
}
\description{
This function performs a PCA to reduce the dataset to two dimensions. Then, it draws the points, marks the center of the groups, the exact groups and the obtained groups.
}
\examples{

data=iris[,-5]
exact_grouping=list(which(iris[,5]=="setosa"),
                   which(iris[,5]=="versicolor"),
                   which(iris[,5]=="virginica"))

grouping=list(c(1:40),c(41:90),c(91:150))
k=3
centers=rbind(c(1,2,3,4),c(2,3,4,5),c(4,5,6,7))

ClustPlot(data, grouping, exact_grouping,centers, k)


}
