% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{calculate_diagnostics}
\alias{calculate_diagnostics}
\title{Calculate MCMC diagnostics}
\usage{
calculate_diagnostics(
  samples,
  burnin_frac = 0.2,
  param_names = NULL,
  title = ""
)
}
\arguments{
\item{samples}{Matrix of MCMC samples (iterations x parameters).}

\item{burnin_frac}{Fraction of samples to discard as burn-in.}

\item{param_names}{Optional character vector of parameter names.}

\item{title}{Optional title for printed output.}
}
\value{
A data frame with posterior summaries and effective sample sizes.
}
\description{
Computes posterior summaries (mean, SD, quantiles) and
effective sample sizes after discarding a burn-in fraction.
}
\examples{
log_post <- function(x) dnorm(x, log = TRUE)
res <- twalk(log_post, n_iter = 2000, x0 = -2, xp0 = 2)
calculate_diagnostics(
  res$all_samples,
  burnin_frac = 0.2,
  param_names = "theta",
  title = "Standard normal"
)

}
