% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{states_dictionary}
\alias{states_dictionary}
\title{States dictionary for standardizing state and province names and codes}
\format{
A named list with two data frames:

\describe{
\item{states_name}{A data frame with columns:
\describe{
\item{state_name}{Character. Name variants of states or provinces
from \code{ne_states()}, lowercased and accent-stripped.}
\item{state_suggested}{Character. Standardized state/province name,
also lowercased and accent-stripped.}
\item{country}{Character. Country associated with the state/province,
lowercased and accent-stripped.}
}
}
\item{states_code}{A data frame with columns:
\describe{
\item{state_code}{Character. Postal codes from \code{ne_states()}, cleaned
and converted to uppercase.}
\item{state_suggested}{Character. Standardized state/province name
corresponding to the code.}
\item{country}{Character. Country associated with the code.}
}
}
}
}
\usage{
states_dictionary
}
\description{
Provides lookup tables used to standardize subnational administrative units
(states and provinces) in occurrence datasets.

Generated from \code{rnaturalearth::ne_states()}, it includes a wide range of
name variants (in multiple languages, transliterations, and common
abbreviations), as well as postal codes for each unit.

This dictionary allows consistent mapping of user-provided names such as
\code{"são paulo"}, \code{"sao paulo"}, \code{"SP"}, \code{"illinois"}, \code{"ill."}, \code{"bayern"},
\code{"bavaria"} to a single standardized state or province name.
}
\details{
The dictionary is constructed by:
\itemize{
\item selecting administrative units of type \code{"State"} or \code{"Province"};
\item extracting multiple name fields, including alternative names and
multilingual fields;
\item normalizing names to lowercase and removing accents;
\item normalizing codes to uppercase;
\item removing duplicates and ambiguous entries;
\item removing rows with missing names or codes.
}
}
\examples{
data(states_dictionary)
head(states_dictionary$states_name)
head(states_dictionary$states_code)
}
\keyword{datasets}
