% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JuxtaOCDs.R
\name{JuxtaOCDs}
\alias{JuxtaOCDs}
\title{Juxtaposed Method for Optimal Covariate Designs (OCDs)}
\usage{
JuxtaOCDs(design)
}
\arguments{
\item{design}{Input a design in matrix format and block size k such that (k+1) is a prime number.}
}
\value{
Generates W matrices and Inter product sums of W matrices.
}
\description{
Consider L matrix, construct resolvable sets by grouping columns into pairs that have the same ordered set of elements. For each pair, arrange the two column-sets horizontally (2(s-1)) and change the signs of any two sets. This new setup form the P_i matrix of order 2(s-1) x 2. Then superimpose the first column of P_i onto N and that produce W_i, where first set of order v x b will be W_i^11 and other set below is W_i^21. Likewise use second column of P_i  to  get W_i^12 and W_i^22.  Repeat for every P_i to get collection of W_i's. The grand total of Hadamard product of all W_i^ij will be zero provided a foldover of any one of the W_i^ij is taken.
}
\examples{
library(SFOCDs)
mat1<-matrix(c(
1,2,3,4,5,6,
7,8,9,10,11,1,
12,13,14,15,2,7,
16,17,18,3,8,12,
19,20,4,9,13,16,
21,5,10,14,17,19,
6,11,15,18,20,21),nrow=7,byrow=TRUE)
JuxtaOCDs(mat1)
}
\references{
Das, K., N. K. Mandal, and B. K. Sinha. (2003) <https://doi.org/10.1016/S0378-3758(02)00151-9>. Optimal experimental designs for models with covariates. Journal of Statistical Planning and Inference 115(1): 273-285.

Bansal, N., and D. K. Garg. (2022)<https://doi.org/10.1007/s42519-022-00244-0>. Optimum covariate designs for three associate PBIB designs. Journal of Statistical Theory and Practice 16(3): 1-15.
}
\author{
Neethu RS

Cini Varghese

Mohd Harun

Anindita Datta

Ashutosh Dalal
}
