% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iRfcb_functions.R
\name{positions_are_near_land}
\alias{positions_are_near_land}
\title{Determine if positions are near land}
\usage{
positions_are_near_land(
  latitudes,
  longitudes,
  distance = 500,
  shape = NULL,
  source = "obis",
  crs = 4326,
  remove_small_islands = TRUE,
  small_island_threshold = 2e+06,
  plot = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{latitudes}{Numeric vector of latitudes for positions.}

\item{longitudes}{Numeric vector of longitudes for positions. Must be the same length as \code{latitudes}.}

\item{distance}{Buffer distance (in meters) from the coastline to consider "near land." Default is 500 meters.}

\item{shape}{Optional path to a shapefile (\code{.shp}) containing coastline data. If provided,
this file will be used instead of the default OBIS land vectors.
A high-resolution shapefile can improve the accuracy of buffer distance calculations.
You can retrieve a more detailed European coastline by setting the \code{source} argument to \code{"eea"}.
Downloaded shape files are cached across R sessions in a user-specific cache directory.}

\item{source}{Character string indicating which default coastline source to use when \code{shape = NULL}.
Options are \code{"obis"} (Ocean Biodiversity Information System, default),
\code{"ne"} (Natural Earth 1:10 vectors) and \code{"eea"} (European Environment Agency).
Ignored if \code{shape} is provided.}

\item{crs}{Coordinate reference system (CRS) to use for input and output.
Default is EPSG code 4326 (WGS84).}

\item{remove_small_islands}{Logical indicating whether to remove small islands from
the coastline. Useful in archipelagos. Default is \code{TRUE}.}

\item{small_island_threshold}{Area threshold in square meters below which islands
will be considered small and removed, if remove_small_islands is set to \code{TRUE}. Default is 2 square km.}

\item{plot}{A boolean indicating whether to plot the points, land polygon and buffer. Default is \code{FALSE}.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}
}
\value{
If \code{plot = FALSE} (default), a logical vector is returned indicating whether each position
is near land or not, with \code{NA} for positions where coordinates are missing.
If \code{plot = TRUE}, a \code{ggplot} object is returned showing the land polygon, buffer area,
and position points colored by their proximity to land.
}
\description{
This function is a \strong{wrapper/re-export} of
\code{iRfcb::ifcb_is_near_land()}. The \code{iRfcb} package is only required
if you want to actually call this function.
}
\details{
Determines whether given positions are near land based on a land polygon shape file.

This function calculates a buffered area around the coastline using a polygon shapefile and
determines if each input position intersects with this buffer or the landmass itself.
By default, it uses the OBIS land vector dataset.

The EEA shapefile is downloaded from \url{https://www.eea.europa.eu/data-and-maps/data/eea-coastline-for-analysis-2/gis-data/eea-coastline-polygon}
when \code{source = "eea"}.
}
\examples{
\donttest{
# Define coordinates
latitudes <- c(62.500353, 58.964498, 57.638725, 56.575338)
longitudes <- c(17.845993, 20.394418, 18.284523, 16.227174)

# Call the function
near_land <- positions_are_near_land(latitudes, longitudes, distance = 300, crs = 4326)

# Print the result
print(near_land)
}

}
\seealso{
\code{\link[=clean_shark4r_cache]{clean_shark4r_cache()}} to manually clear cached shape files.

\code{\link[iRfcb:ifcb_is_near_land]{iRfcb::ifcb_is_near_land}} for the original function.
}
