% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantLDs.R
\name{findProxy}
\alias{findProxy}
\title{Finds variants in high LD}
\usage{
findProxy(
  rslist,
  file = NULL,
  build = "38",
  db = "1000GENOMES:phase_3:EUR",
  window_size = 500,
  r2 = 0.8
)
}
\arguments{
\item{rslist}{A vector of rs numbers.}

\item{file}{Path to the Excel file for saving search results.}

\item{build}{Genome build. Either 37 or 38. default: 38}

\item{db}{The population database for calculating LD scores.
This can be found using \code{Ensembl.Databases()} function. default: 1000GENOMES:phase_3:EUR}

\item{window_size}{Number of base pairs around the variant for checking LD scores (max = 500kb). default: 500}

\item{r2}{The minimum LD threshold for selecting variants around the target SNP. default: 0.8.}
}
\value{
A data table with variant information.
}
\description{
This function returns a list of variables that are in high LD with a list of selected variants using data from the Ensembl website.
}
