% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FERS.R
\name{FERS}
\alias{FERS}
\title{P values for shapes obtained from semi-parametric shape-restricted fixed effect regression splines.}
\usage{
FERS(
  y,
  xMain,
  xConf = NULL,
  dataset,
  knotType = 2,
  preKnot = NULL,
  nBasis = 5,
  nIter
)
}
\arguments{
\item{y}{The name of the outcome.}

\item{xMain}{The name of the main effect.}

\item{xConf}{The name vector of the confounders.}

\item{dataset}{A data frame.}

\item{knotType}{The knot type: 1=equal-spaced, 2=quantile, 3=pre-specified.}

\item{preKnot}{The pre-specified knots.}

\item{nBasis}{The number of bases.}

\item{nIter}{The number of iterations.}
}
\value{
A list of weights of beta distribution and p-values.
}
\description{
P values for shapes obtained from semi-parametric shape-restricted fixed effect regression splines.
}
\examples{
shape <- FERS(y = "ySim", xMain = "hormone",
              xConf = c("age", "invwt", "race2", "race3", "race4", "race5",
                        "season2", "season3", "season4", "smoking1", "ovum1", "diabetes1"),
              dataset = data.sim.fixed, nBasis = 5, nIter = 50)
shape
}
