% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_st_intensity_point.R
\name{estimate.intensity.point}
\alias{estimate.intensity.point}
\title{Kernel intensity estimates of a spatio-temporal point process at observed points and its components,
and test statistics for first-order separability}
\usage{
estimate.intensity.point(X, n.grid, edge)
}
\arguments{
\item{X}{Numeric matrix/data.frame with three columns \code{(x,y,t)} giving event coordinates.}

\item{n.grid}{Integer. Included for API compatibility with grid-based routines; not used.}

\item{edge}{List with components \code{bw} (length 3), \code{space}, and \code{time}.
\code{space} and \code{time} are Gaussian edge-correction masses evaluated at each event;
each may be a scalar or a numeric vector of length \code{nrow(X)}.}
}
\value{
A list with components \code{S.fun}, deviation measures, and estimated
intensity components at the observed points.
}
\description{
Computes kernel-based spatial, temporal, separable, and non-separable intensity
estimates evaluated at the observed spatio-temporal event locations. The function
also returns the separability diagnostic \eqn{S_i} and global deviation measures
quantifying departures from first-order separability.
}
\details{
Pairwise Gaussian kernel weights are computed in each dimension and diagonal
entries are set to zero to remove self-contributions.
}
\examples{

X <- cbind(stats::runif(50), stats::runif(50), stats::runif(50))
edge <- list(bw = c(0.1, 0.1, 0.1), space = 1, time = 1)
res <- estimate.intensity.point(X, n.grid = 50, edge = edge)
str(res)


}
\seealso{
\code{\link[stats]{dnorm}}
}
