% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_envelope_test.R
\name{global.envelope.test}
\alias{global.envelope.test}
\title{Global envelope test for spatio-temporal separability using S-function}
\usage{
global.envelope.test(
  X,
  sim.procedure = c("pure_per", "block_per"),
  nsim = 25L,
  nblocks = 5L,
  nperm = 199L,
  n.grid = c(20L, 20L, 10L),
  s.region = matrix(c(0, 0, 1, 0, 1, 1, 0, 1), ncol = 2, byrow = TRUE),
  t.region = c(0, 1),
  owin = NULL,
  eps = NULL,
  del = NULL,
  tests = c("S.test", "S.space.test", "S.time.test"),
  GET.args = NULL
)
}
\arguments{
\item{X}{A numeric matrix or data frame with at least three columns giving \eqn{(x,y,t)}.}

\item{sim.procedure}{Character string specifying the permutation strategy:
\code{"pure_per"} or \code{"block_per"}.}

\item{nsim}{Integer. Number of permutations for \code{"pure_per"}.}

\item{nblocks}{Integer (>= 2). Number of temporal blocks for block permutation.
Used only for \code{"block_per"}.}

\item{nperm}{Integer. Number of block permutations for \code{"block_per"}.}

\item{n.grid}{Integer/numeric vector of length 3 specifying grid resolution in \eqn{x,y,t}.}

\item{s.region}{Numeric matrix with two columns specifying polygon vertices of the spatial window.}

\item{t.region}{Numeric vector of length 2 specifying temporal window \code{c(tmin,tmax)}.}

\item{owin}{Optional window of class \code{"owin"} (from \pkg{spatstat.geom}). If supplied,
values outside the window are set to \code{NA} (pixels mode).}

\item{eps}{Optional numeric scalar (>0). Spatial bandwidth. If \code{NULL}, estimated internally.}

\item{del}{Optional numeric scalar (>0). Temporal bandwidth. If \code{NULL}, estimated internally.}

\item{tests}{Character vector indicating which diagnostics to test. Any of
\code{"S.test"}, \code{"S.space.test"}, \code{"S.time.test"}.}

\item{GET.args}{Optional named list of extra arguments passed to
\code{\link[GET]{global_envelope_test}} (e.g. \code{alternative}, \code{savefuns}, \code{nstep}).}
}
\value{
A list with components:
\describe{
\item{Bandwidth_s}{Spatial bandwidth used.}
\item{Bandwidth_t}{Temporal bandwidth used.}
\item{S.test, S.space.test, S.time.test}{For each requested test: p-values for ERL and AREA envelopes,
plus optional plots if created.}
}
}
\description{
Performs a global envelope test of the null hypothesis of first-order separability
for a spatio-temporal point process. The observed separability diagnostics
\eqn{S(u,t)}, \eqn{S_{\mathrm{space}}(u)} and/or \eqn{S_{\mathrm{time}}(t)} are compared
to a reference distribution obtained from permuted versions of the data.
}
\details{
Two permutation strategies are supported:
\describe{
\item{\code{"pure_per"}}{Pure permutation: randomly permutes the time coordinates.}
\item{\code{"block_per"}}{Block permutation: permutes time in blocks to preserve short-range temporal dependence.}
}

The \pkg{GET} package is used to construct global envelopes and compute p-values.

The null hypothesis is
\deqn{H_0:\ \rho(u,t)=\rho_{\mathrm{space}}(u)\rho_{\mathrm{time}}(t).}
The function computes the chosen diagnostics using \code{\link{S.based.functions}}
on a pixel grid (\code{at="pixels"}) and applies \code{\link[GET]{global_envelope_test}}.

To keep curve lengths identical (required by \pkg{GET}), any \code{NA} values induced by
an \code{owin} mask are removed using the \strong{same indices} for the observed and all simulated curves.
}
\examples{

if (requireNamespace("GET", quietly = TRUE)) {
  set.seed(123)
  X <- cbind(stats::runif(100), stats::runif(100), stats::runif(100, 0, 1))
  s.region <- matrix(c(0,0, 1,0, 1,1, 0,1), ncol = 2, byrow = TRUE)
  t.region <- c(0, 1)

  res <- global.envelope.test(
    X = X,
    sim.procedure = "pure_per",
    nsim = 19,
    n.grid = c(10,10,10),
    s.region = s.region,
    t.region = t.region,
    tests = c("S.test","S.time.test")
  )
  str(res)
}

}
\references{
Ghorbani, M., Vafaei, N., Dvořák, J., and Myllymäki, M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{S.based.functions}},
\code{\link{sim.procedures}},
\code{\link{block.permut}},
\code{\link[GET]{global_envelope_test}},
\code{\link[GET]{plot.global_envelope}}
}
\author{
Nafiseh Vafaei \email{nafiseh.vafaei@slu.se}\cr
Mohammad Ghorbani \email{mohammad.ghorbani@slu.se}
}
