% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\name{createDesign}
\alias{createDesign}
\alias{print.Design}
\alias{[.Design}
\alias{rbindDesign}
\title{Create the simulation design object}
\usage{
createDesign(
  ...,
  subset,
  fractional = NULL,
  tibble = TRUE,
  stringsAsFactors = FALSE,
  fully.crossed = TRUE
)

\method{print}{Design}(x, list2char = TRUE, pillar.sigfig = 5, show.IDs = FALSE, ...)

\method{[}{Design}(x, i, j, ..., drop = FALSE)

rbindDesign(..., keep.IDs = FALSE)
}
\arguments{
\item{...}{comma separated list of named input objects representing the simulation
factors to completely cross. Note that these arguments are passed to
\code{\link{expand.grid}} to perform the complete crossings}

\item{subset}{(optional) a logical vector indicating elements or rows to keep
to create a partially crossed simulation design}

\item{fractional}{a fractional design matrix returned from the
\code{FrF2} package.
Note that the order of the factor names/labels are associated with the
respective \code{...} inputs}

\item{tibble}{logical; return a \code{tibble} object instead of a
\code{data.frame}? Default is TRUE}

\item{stringsAsFactors}{logical; should character variable inputs be coerced
to factors when building a \code{data.frame}? Default is FALSE}

\item{fully.crossed}{logical; create a fully-crossed design object? Setting to \code{FALSE}
will attempt to combine the design elements column-wise via \code{data.frame(...)}
instead of \code{expand.grid(...)}}

\item{x}{object of class \code{'Design'}}

\item{list2char}{logical; for \code{tibble} object re-evaluate list elements
as character vectors for better printing of the levels? Note that this
does not change the original classes of the object, just how they are printed.
Default is TRUE}

\item{pillar.sigfig}{number of significant digits to print. Default is 5}

\item{show.IDs}{logical; print the internally stored Design ID indicators?}

\item{i}{row index}

\item{j}{column index}

\item{drop}{logical; drop to lower dimension class?}

\item{keep.IDs}{logical; keep the internal ID variables in the
\code{Design} objects? Use this when row-binding conditions
that are matched with previous conditions
(e.g., when using \code{\link{expandDesign}})}
}
\value{
a \code{tibble} or \code{data.frame} containing the simulation experiment
  conditions to be evaluated in \code{\link{runSimulation}}
}
\description{
Create a partially or fully-crossed data object reflecting the unique
simulation design conditions. Each row of the returned object represents
a unique simulation condition, and each column represents the named factor
variables under study.
}
\examples{
\dontrun{

# modified example from runSimulation()

Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2))
Design

# remove N=10, SD=2 row from initial definition
Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       subset = !(N == 10 & SD == 2))
Design

# example with list inputs
Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       combo = list(c(0,0), c(0,0,1)))
Design   # notice levels printed (not typical for tibble)
print(Design, list2char = FALSE)   # standard tibble output

Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2),
                       combo = list(c(0,0), c(0,0,1)),
                       combo2 = list(c(5,10,5), c(6,7)))
Design
print(Design, list2char = FALSE)   # standard tibble output

# design without crossing (inputs taken-as is)
Design <- createDesign(N = c(10, 20),
                       SD = c(1, 2), cross=FALSE)
Design   # only 2 rows

##########

## fractional factorial example

library(FrF2)
# help(FrF2)

# 7 factors in 32 runs
fr <- FrF2(32,7)
dim(fr)
fr[1:6,]

# Create working simulation design given -1/1 combinations
fDesign <- createDesign(sample_size=c(100,200),
                        mean_diff=c(.25, 1, 2),
                        variance.ratio=c(1,4, 8),
                        equal_size=c(TRUE, FALSE),
                        dists=c('norm', 'skew'),
                        same_dists=c(TRUE, FALSE),
                        symmetric=c(TRUE, FALSE),
                        # remove same-normal combo
                        subset = !(symmetric & dists == 'norm'),
                        fractional=fr)
fDesign

}
}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{expandDesign}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
