% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Markers_filter_Cellmarker2.R
\name{Markers_filter_Cellmarker2}
\alias{Markers_filter_Cellmarker2}
\title{Create Marker_list from the Cellmarkers2 database}
\usage{
Markers_filter_Cellmarker2(
  df,
  species = NULL,
  tissue_class = NULL,
  tissue_type = NULL,
  cancer_type = NULL,
  cell_type = NULL
)
}
\arguments{
\item{df}{Standardized Cellmarkers2 database. It is read as data(Cellmarkers2)
in the SlimR library.}

\item{species}{Species information in Cellmarkers2 database. The default
input is "Human" or "Mouse".The input can be retrieved by "Cellmarkers2_table".
For more information,please refer to http://117.50.127.228/CellMarker/ on
Cellmarkers2's official website.}

\item{tissue_class}{Tissue_class information in Cellmarkers2 database.
The input can be retrieved by "Cellmarkers2_table". For more information,
please refer to http://117.50.127.228/CellMarker/ on Cellmarkers2's official
website.}

\item{tissue_type}{Tissue_type information in Cellmarkers2 database.
The input can be retrieved by "Cellmarkers2_table". For more information,
please refer to http://117.50.127.228/CellMarker/ on Cellmarkers2's official
website.}

\item{cancer_type}{Cancer_type information in Cellmarkers2 database.
The input can be retrieved by "Cellmarkers2_table". For more information,
please refer to http://117.50.127.228/CellMarker/ on Cellmarkers2's official
website.}

\item{cell_type}{Cell_type information in Cellmarkers2 database.
The input can be retrieved by "Cellmarkers2_table". For more information,
please refer to http://117.50.127.228/CellMarker/ on Cellmarkers2's official
website.}
}
\value{
The standardized "Marker_list" in the SlimR package
}
\description{
Create Marker_list from the Cellmarkers2 database
}
\examples{
Cellmarker2 <- SlimR::Cellmarker2
Markers_list_Cellmarker2 <- Markers_filter_Cellmarker2(
    Cellmarker2,
    species = "Human",
    tissue_class = "Intestine",
    tissue_type = NULL,
    cancer_type = NULL,
    cell_type = NULL
    )

}
\seealso{
Other Section_2_Standardized_Markers_List: 
\code{\link{Markers_filter_PanglaoDB}()},
\code{\link{Read_excel_markers}()},
\code{\link{Read_seurat_markers}()}
}
\concept{Section_2_Standardized_Markers_List}
