% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_FindAllMarkers.R
\name{supercell_FindAllMarkers}
\alias{supercell_FindAllMarkers}
\title{Differential expression analysis of supep-cell data. Most of the parameters are the same as in Seurat \link[Seurat]{FindAllMarkers} (for simplicity)}
\usage{
supercell_FindAllMarkers(
  ge,
  clusters,
  supercell_size = NULL,
  genes.use = NULL,
  logfc.threshold = 0.25,
  min.expr = 0,
  min.pct = 0.1,
  seed = 12345,
  only.pos = FALSE,
  return.extra.info = FALSE,
  do.bootstrapping = FALSE
)
}
\arguments{
\item{ge}{gene expression matrix for super-cells (rows - genes, cols - super-cells)}

\item{clusters}{a vector with clustering information (ordered the same way as in \code{ge})}

\item{supercell_size}{a vector with supercell size (ordered the same way as in \code{ge})}

\item{genes.use}{set of genes to test. Defeult -- all genes in \code{ge}}

\item{logfc.threshold}{log fold change threshold for genes to be considered in the further analysis}

\item{min.expr}{minimal expression (default 0)}

\item{min.pct}{remove genes with lower percentage of detection from the set of genes which will be tested}

\item{seed}{random seed to use}

\item{only.pos}{whether to compute only positive (upregulated) markers}

\item{return.extra.info}{whether to return extra information about test and its statistics. Default is FALSE.}

\item{do.bootstrapping}{whether to perform bootstrapping when computing standard error and p-value in \link[weights]{wtd.t.test}}
}
\value{
list of results of \link[SuperCell]{supercell_FindMarkers}
}
\description{
Differential expression analysis of supep-cell data. Most of the parameters are the same as in Seurat \link[Seurat]{FindAllMarkers} (for simplicity)
}
