% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fit2.R
\name{plot_fit2}
\alias{plot_fit2}
\title{Plotting the distributions of selected simulated fit indices}
\usage{
plot_fit2(
  fits = NULL,
  correct.fits = NULL,
  miss.fits = NULL,
  index = "CFI",
  alpha = 0.05,
  beta = 0.1
)
}
\arguments{
\item{fits}{The object returned from gen_fit2 which is a list of correct fit values and misspecified fit values.}

\item{correct.fits}{For compatibility reasons, the correct fit values can be defined separately.}

\item{miss.fits}{For compatibility reasons, the misspecified fit values can be defined separately.}

\item{index}{A vector of length >= 1 with names of fit indices the user wishes to explore. Capitalization does not matter, either e.g., CFI or cfi are accepted. Default is CFI as it might be easier to understand.}

\item{alpha}{The acceptable Type I error representing the empirical quantile p, see details in gen_fit2. Multiple values can be provided as a vector.  Default is .05.}

\item{beta}{The acceptable Type II error representing the empirical quantile p, see details in gen_fit2. Multiple values can be provided as a vector. Default is c(.05, .10).}
}
\value{
A ggplot2 object with the simulated cutoffs for correct and misspecified models iterated across the number of indices provided.
}
\description{
Plotting the distributions of selected simulated fit indices
}
\details{
For details, please refer to gen_fit2. Please note that the results are only based on the simulation of the model specified and its misspecified variant under the conditions of the gen_fit2 function.
}
\examples{
\donttest{#Simple example
library(lavaan)
library(dplyr)
HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
             speed   =~ x7 + x8 + x9 '

fit <- cfa(
  HS.model,
  data = HolzingerSwineford1939
)
#Note: Demonstration only! Please use higher numbers of replications for your applications (>= 500).
fits <- gen_fit2(fit = fit, rep = 100)
#Default plot:
plot_fit2(fits)
#Changed alpha and beta values:
plot_fit2(fits, alpha = .05, beta = .05)
plot_fit2(fits, alpha = .10, beta = .20)
#Different fit indices:
plot_fit2(fits, index = c("CFI", "SRMR", "RMSEA"))}
}
