% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCmodel.R
\name{UCsetup}
\alias{UCsetup}
\title{UCsetup}
\usage{
UCsetup(
  y,
  u = NULL,
  model = "?/none/?/?",
  h = 24,
  lambda = 1,
  outlier = 9999,
  tTest = FALSE,
  criterion = "aic",
  periods = NA,
  verbose = FALSE,
  stepwise = FALSE,
  p0 = -9999.9,
  arma = FALSE,
  TVP = NULL,
  trendOptions = "none/rw/llt/dt",
  seasonalOptions = "none/equal/different",
  irregularOptions = "none/arma(0,0)"
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{periods} should be supplied compulsorily (see below).}

\item{u}{a matrix of external regressors included only in the observation equation. 
(it may be either a numerical vector or a time series object). If the output wanted 
to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of 
model for each component. It allows two formats "trend/seasonal/irregular" or 
"trend/cycle/seasonal/irregular". The possibilities available for each component are:
\itemize{
\item Trend: ? / none / rw / irw / llt / dt / td; 

\item Seasonal: ? / none / equal / different;

\item Irregular: ? / none / arma(0, 0) / arma(p, q) - with p and q integer positive orders;
    
\item Cycles: ? / none / combination of positive or negative numbers. Positive numbers fix
the period of the cycle while negative values estimate the period taking as initial
condition the absolute value of the period supplied. Several cycles with positive or negative values are possible
and if a question mark is included, the model test for the existence of the cycles
specified. The following are valid examples with different meanings: 48, 48?, -48, -48?,
48+60, -48+60, -48-60, 48-60, 48+60?, -48+60?, -48-60?, 48-60?.
}}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{lambda}{Box-Cox transformation lambda, NULL for automatic estimation}

\item{outlier}{critical level of outlier tests. If NA it does not carry out any 
outlier detection (default). A positive value indicates the critical minimum
t test for outlier detection in any model during identification. Three types of outliers are
identified, namely Additive Outliers (AO), Level Shifts (LS) and Slope Change (SC).}

\item{tTest}{augmented Dickey Fuller test for unit roots used in stepwise algorithm (TRUE / FALSE). 
The number of models to search for is reduced, depending on the result of this test.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{periods}{vector of fundamental period and harmonics required.}

\item{verbose}{intermediate results shown about progress of estimation (TRUE / FALSE).}

\item{stepwise}{stepwise identification procedure (TRUE / FALSE).}

\item{p0}{initial parameter vector for optimisation search.}

\item{arma}{check for arma models for irregular components (TRUE / FALSE).}

\item{TVP}{vector of zeros and ones to indicate TVP parameters.}

\item{trendOptions}{trend models to select amongst (e.g., "rw/llt").}

\item{seasonalOptions}{seasonal models to select amongst (e.g., "none/differentt").}

\item{irregularOptions}{irregular models to select amongst (e.g., "none/arma(0,1)").}
}
\value{
An object of class \code{UComp}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{UComp} object as specified in what follows (function 
        \code{UC} fills in all of them at once):

After running \code{UCforecast}:
\itemize{
\item p:        Estimated parameters
\item v:        Estimated innovations (white noise in correctly specified models)
\item yFor:     Forecasted values of output
\item yForV:    Variance of forecasts
\item criteria: Value of criteria for estimated model
\item iter:     Number of iterations in estimation
\item grad:     Gradient at estimated parameters
\item covp:     Covariance matrix of parameters
}

After running \code{UCvalidate}:
\itemize{
\item table: Estimation and validation table
}

After running \code{UCcomponents}:
\itemize{
\item comp:      Estimated components in matrix form
\item compV:     Estimated components variance in matrix form
}

After running \code{UCfilter}, \code{UCsmooth} or  \code{UCdisturb}:
\itemize{
\item yFit:  Fitted values of output
\item yFitV: Estimated fitted values variance
\item a:     State estimates
\item P:     Variance of state estimates
\item aFor:  Forecasts of states
\item PFor:  Forecasts of states variances
}

After running \code{UCdisturb}:
\itemize{
\item eta: State perturbations estimates
\item eps: Observed perturbations estimates
}

Standard methods applicable to UComp objects are print, summary, plot,
fitted, residuals, logLik, AIC, BIC, coef, predict, tsdiag.
}
\description{
Sets up UC general univariate models
}
\details{
See help of \code{UC}.
}
\examples{
\donttest{
y <- log(AirPassengers)
m1 <- UCsetup(y)
m1 <- UCsetup(y, outlier = 4)
m1 <- UCsetup(y, model = "llt/equal/arma(0,0)")
m1 <- UCsetup(y, model = "?/?/?/?")
m1 <- UCsetup(y, model = "llt/?/equal/?", outlier = 4)
}
}
\seealso{
\code{\link{UC}}, \code{\link{UCforecast}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}},
         \code{\link{UChp}}
}
\author{
Diego J. Pedregal
}
