#' Impulse response function
#'
#' Computes the impulse response coefficients of a VAR(p)
#' (or transformed VECM to VAR(p)) for n.ahead steps.
#'
#' This function runs \code{vars::irf()} for an object of class "varshrinkest".
#'
#' @param x Object of class "varshrinkest",
#' generated by \code{VARshrink()}
#' @param impulse A character vector of the impulses,
#' default is all variables.
#' @param response A character vector of the responses,
#' default is all variables.
#' @param n.ahead Integer specifying the steps.
#' @param ortho Logical, if TRUE (the default) the
#' orthogonalised impulse response coefficients are
#' computed (only for objects of class 'varshrinkest').
#' @param cumulative Logical, if TRUE the cumulated impulse
#' response coefficients are computed. The default value
#' is false.
#' @param boot Logical, if TRUE (the default) bootstrapped
#' error bands for the imuplse response coefficients are
#' computed.
#' @param ci Numeric, the confidence interval for the
#' bootstrapped errors bands.
#' @param runs An integer, specifying the runs for the
#' bootstrap.
#' @param seed An integer, specifying the seed for the
#' rng of the bootstrap.
#' @param ... Currently not used.
#' @returns An object of class "varirf", computed by \code{vars::irf()}.
#' @seealso \code{\link[vars]{irf}}
#' @export
irf.varshrinkest <-
  function(x, impulse = NULL, response = NULL, n.ahead = 10, ortho = TRUE,
           cumulative = FALSE, boot = TRUE, ci = 0.95, runs = 100, seed = NULL,
           ...) {
    if (!inherits(x, "varest")) {
      stop("\nPlease provide an object inheriting class 'varest'.\n")
    }
    if (!identical(class(x), "varest")) {
      class(x) <- "varest"
    }
    result <- vars::irf(x, impulse = impulse, response = response,
                        n.ahead = n.ahead, ortho = ortho,
                        cumulative = cumulative, boot = boot, ci = ci,
                        runs = runs, seed = seed, ...)
    return(result)
  }
