% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Juggler.Nsteps.R
\name{Juggler.Nsteps}
\alias{Juggler.Nsteps}
\alias{A007320}
\title{Number of steps for Juggler sequence}
\usage{
Juggler.Nsteps(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A007320}{A007320}, a \emph{Number of steps for Juggler sequence} literally counts the number of steps
required for a sequence that starts from \code{n}. First 6 terms are  	0, 1, 6, 2, 5, 2 that \code{n} starting from 0 is conventional choice.
Note that when it counts \emph{number of steps}, not the length of the sequence including the last 1.
}
\examples{
## generate first 10 numbers of steps for Juggler sequences
print(Juggler.Nsteps(10))

}
\seealso{
\code{\link{Juggler}}
}
