% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmarginals.R
\name{getmarginals}
\alias{getmarginals}
\title{Internal function called by \code{fitAbn.bayes}.}
\usage{
getmarginals(
  res.list,
  data.df,
  dag.m,
  var.types,
  max.parents,
  mean,
  prec,
  loggam.shape,
  loggam.inv.scale,
  max.iters,
  epsabs,
  verbose,
  error.verbose,
  trace,
  grouped.vars,
  group.ids,
  epsabs.inner,
  max.iters.inner,
  finite.step.size,
  hessian.params,
  max.iters.hessian,
  min.pdf,
  marginal.node,
  marginal.param,
  variate.vec,
  n.grid,
  INLA.marginals,
  iter.max,
  max.hessian.error,
  factor.brent,
  maxiters.hessian.brent,
  num.intervals.brent
)
}
\arguments{
\item{res.list}{rest of arguments as for call to C fitabn}

\item{data.df}{a data frame containing the data used for learning the network, binary variables must be declared as factors, and no missing values all allowed in any variable.}

\item{dag.m}{adjacency matrix}

\item{var.types}{distributions in terms of a numeric code}

\item{max.parents}{max number of parents over all nodes in dag (different from other \code{max.parents} definitions).}

\item{mean}{the prior mean for all the Gaussian additive terms for each node. INLA argument \code{control.fixed=list(mean.intercept=...)} and \code{control.fixed=list(mean=...)}.}

\item{prec}{the prior precision (\eqn{\tau = \frac{1}{\sigma^2}}) for all the Gaussian additive term for each node. INLA argument \code{control.fixed=list(prec.intercept=...)} and \code{control.fixed=list(prec=...)}.}

\item{loggam.shape}{the shape parameter in the Gamma distribution prior for the precision in a Gaussian node. INLA argument \code{control.family=list(hyper = list(prec = list(prior="loggamma",param=c(loggam.shape, loggam.inv.scale))))}.}

\item{loggam.inv.scale}{the inverse scale parameter in the Gamma distribution prior for the precision in a Gaussian node. INLA argument \code{control.family=list(hyper = list(prec = list(prior="loggamma",param=c(loggam.shape, loggam.inv.scale))))}.}

\item{max.iters}{total number of iterations allowed when estimating the modes in Laplace approximation. passed to \code{.Call("fit_single_node", ...)}.}

\item{epsabs}{absolute error when estimating the modes in Laplace approximation for models with no random effects. Passed to \code{.Call("fit_single_node", ...)}.}

\item{verbose}{if \code{TRUE} then provides some additional output, in particular the code used to call INLA, if applicable.}

\item{error.verbose}{logical, additional output in the case of errors occurring in the optimization. Passed to \code{.Call("fit_single_node", ...)}.}

\item{trace}{Non-negative integer. If positive, tracing information on the progress of the "L-BFGS-B" optimization is produced. Higher values may produce more tracing information. (There are six levels of tracing.  To understand exactly what these do see the source code.). Passed to \code{.Call("fit_single_node", ...)}.}

\item{grouped.vars}{result returned from \code{\link{check.valid.groups}}. Column indexes of all variables which are affected from grouping effect.}

\item{group.ids}{result returned from \code{\link{check.valid.groups}}. Vector of group allocation for each observation (row) in 'data.df'.}

\item{epsabs.inner}{absolute error in the maximization step in the (nested) Laplace approximation for each random effect term. Passed to \code{.Call("fit_single_node", ...)}.}

\item{max.iters.inner}{total number of iterations in the maximization step in the nested Laplace approximation. Passed to \code{.Call("fit_single_node", ...)}.}

\item{finite.step.size}{suggested step length used in finite difference estimation of the derivatives for the (outer) Laplace approximation when estimating modes. Passed to \code{.Call("fit_single_node", ...)}.}

\item{hessian.params}{a numeric vector giving parameters for the adaptive algorithm, which determines the optimal stepsize in the finite-difference estimation of the hessian. First entry is the initial guess, second entry absolute error. Passed to \code{.Call("fit_single_node", ...)}.}

\item{max.iters.hessian}{integer, maximum number of iterations to use when determining an optimal finite difference approximation (Nelder-Mead). Passed to \code{.Call("fit_single_node", ...)}.}

\item{min.pdf}{the value of the posterior density function below which we stop the estimation only used when computing marginals, see details.}

\item{marginal.node}{used in conjunction with \code{marginal.param} to allow bespoke estimate of a marginal density over a specific grid. value from 1 to the number of nodes.}

\item{marginal.param}{used in conjunction with \code{marginal.node}. value of 1 is for intercept, see modes entry in results for the appropriate number.}

\item{variate.vec}{a vector containing the places to evaluate the posterior marginal density, must be supplied if \code{marginal.node} is not null.}

\item{n.grid}{recompute density on an equally spaced grid with \code{n.grid} points.}

\item{INLA.marginals}{vector - TRUE if INLA used false otherwise}

\item{iter.max}{same as \code{max.iters} in \code{\link{fit.control}}. Total number of iterations allowed when estimating the modes in Laplace approximation. Passed to .Call("fit_single_node", ...).}

\item{max.hessian.error}{if the estimated log marginal likelihood when using an adaptive 5pt finite-difference rule for the Hessian differs by more than \code{max.hessian.error} from when using an adaptive 3pt rule then continue to minimize the local error by switching to the Brent-Dekker root bracketing method. Passed to \code{.Call("fit_single_node", ...)}.}

\item{factor.brent}{if using Brent-Dekker root bracketing method then define the outer most interval end points as the best estimate of \eqn{h} (stepsize) from the Nelder-Mead as \eqn{h/factor.brent,h*factor.brent)}. Passed to \code{.Call("fit_single_node", ...)}.}

\item{maxiters.hessian.brent}{maximum number of iterations allowed in the Brent-Dekker method. Passed to \code{.Call("fit_single_node", ...)}.}

\item{num.intervals.brent}{the number of initial different bracket segments to try in the Brent-Dekker method. Passed to \code{.Call("fit_single_node", ...)}.}
}
\value{
A named list with "modes", "error.code", "hessian.accuracy", "error.code.desc", "mliknode", "mlik", "mse", "coef", "used.INLA", "marginals".
}
\description{
Function for computing marginal posterior densities using C and is called from fit.dag()
Only to be called internally.
}
\seealso{
Other Bayes: 
\code{\link{buildScoreCache}()},
\code{\link{calc.node.inla.glm}()},
\code{\link{calc.node.inla.glmm}()},
\code{\link{fitAbn}()}
}
\concept{Bayes}
\keyword{internal}
