% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateabn.R
\name{makebugs}
\alias{makebugs}
\title{Make BUGS model from fitted DAG}
\usage{
makebugs(dag, data.dists, coefs, stderrors)
}
\arguments{
\item{dag}{named adjacency matrix representing the DAG. Names correspond to node names.}

\item{data.dists}{list of node distributions.}

\item{coefs}{a list named by the node names containing for each element a matrix with the nodes' coefficients.}

\item{stderrors}{a list named by the node names containing for each element a matrix with the nodes' standard errors}
}
\value{
Bugs model returned as stdout.
}
\description{
Make BUGS model from fitted DAG
}
\examples{
## Prepare data and arguments
mydists <- list(a="gaussian",
                b="multinomial",
                c="binomial",
                d="poisson")
mydag <- matrix(0, 4, 4, byrow = TRUE,
                dimnames = list(c("a", "b", "c", "d"),
                                c("a", "b", "c", "d")))
mydag[2,1] <- mydag[3,2] <- mydag[4,3] <- 1
# plotAbn(mydag, data.dists = mydists)
mycoefs <- list("a"=matrix(-6.883383e-17, byrow = TRUE,
                           dimnames = list(NULL,
                                           "a|intercept")),
                "b"=matrix(c(2.18865, 3.133928, 3.138531, 1.686432, 3.134161, 5.052104),
                           nrow= 1, byrow = TRUE,
                           dimnames = list(c(NULL),
                                      c("b|intercept.2", "b|intercept.3", "b|intercept.4",
                                      "a.2", "a.3", "a.4"))),
                "c"=matrix(c(1.11, 2.22, 3.33, 4.44, 5.55),
                           nrow= 1, byrow = TRUE,
                           dimnames = list(c(NULL),
                                      c("c|intercept", "b1", "b2", "b3", "b4"))),
                "d"=matrix(c(3.33, 4.44),
                           nrow= 1, byrow = TRUE,
                           dimnames = list(c(NULL),
                                      c("d|intercept", "c"))))
mymse <- c("a"=0,"b"=1,"c"=2,"d"=3)
## Make BUGS model
makebugs(dag = mydag, data.dists = mydists, coefs = mycoefs, stderrors = mymse)

}
\seealso{
\link{simulateAbn} \link{gauss_bugs} \link{bern_bugs} \link{categorical_bugs} \link{pois_bugs}
}
\keyword{internal}
\keyword{utilities}
