% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos.R
\name{adj_from_shp}
\alias{adj_from_shp}
\title{Create an \code{adj} list from a set of spatial polygons}
\usage{
adj_from_shp(shp)
}
\arguments{
\item{shp}{An object convertible to \code{geos} geometries representing polygons, such
as an \code{sf} object, well-known text strings, or \code{geos} geometries.}
}
\value{
An \code{adj} list
}
\description{
Requires that the \code{geos} package be installed.
}
\examples{
shp <- c(
 "POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))",
 "POLYGON ((0 1, 1 1, 1 2, 0 2, 0 1))",
 "POLYGON ((1 0, 2 0, 2 1, 1 1, 1 0))",
 "POLYGON ((1 1, 2 1, 2 2, 1 2, 1 1))"
)

adj_from_shp(shp)
}
