% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aphylo_mle.R
\name{aphylo_mle}
\alias{aphylo_mle}
\alias{MLE}
\title{Model estimation using Maximum Likelihood Estimation}
\usage{
aphylo_mle(
  model,
  params,
  method = "L-BFGS-B",
  priors = function(p) 1,
  control = list(),
  lower = 1e-05,
  upper = 1 - 1e-05,
  check_informative = getOption("aphylo_informative", FALSE),
  reduced_pseq = getOption("aphylo_reduce_pseq", TRUE)
)
}
\arguments{
\item{model}{A model as specified in \link{aphylo-model}.}

\item{params}{A vector of length 7 with initial parameters. In particular
\code{psi[1]}, \code{psi[2]}, \code{mu[1]}, \code{mu[2]}, \code{eta[1]}, \code{eta[2]} and \code{Pi}.}

\item{method, control, lower, upper}{Arguments passed to \code{\link[stats:optim]{stats::optim()}}.}

\item{priors}{A function to be used as prior for the model (see \link{bprior}).}

\item{check_informative}{Logical scalar. When \code{TRUE} the algorithm
stops with an error when the annotations are uninformative (either 0s or 1s).}

\item{reduced_pseq}{Logical. When \code{TRUE} it will use a reduced peeling sequence
in which it drops unannotated leafs. If the model includes \code{eta} this is set
to \code{FALSE}.}
}
\value{
An object of class \link{aphylo_estimates}.
}
\description{
The function is a wrapper of \code{\link[stats:optim]{stats::optim()}}.
}
\details{
The default starting parameters are described in \link{APHYLO_PARAM_DEFAULT}.
}
\examples{

# Using simulated data ------------------------------------------------------
set.seed(19)
dat <- raphylo(100)
dat <- rdrop_annotations(dat, .4)

# Computing Estimating the parameters 
ans  <- aphylo_mle(dat ~ psi + mu_d + eta + Pi)
ans

# Plotting the path
plot(ans)

# Computing Estimating the parameters Using Priors for all the parameters
mypriors <- function(params) {
    dbeta(params, c(2, 2, 2, 2, 1, 10, 2), rep(10, 7))
}

ans_dbeta <- aphylo_mle(dat ~ psi + mu_d + eta + Pi, priors = mypriors)
ans_dbeta
}
\seealso{
Other parameter estimation: 
\code{\link{APHYLO_DEFAULT_MCMC_CONTROL}}
}
\concept{parameter estimation}
