% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.aplms.R
\name{plot.aplms}
\alias{plot.aplms}
\title{Default APLMS plotting}
\usage{
\method{plot}{aplms}(x, len = 100, plot = TRUE, level = 0.95, ...)
}
\arguments{
\item{x}{an object with the result of fitting additive partial linear models with symmetric errors.}

\item{len}{The desired length of the sequence of covariates to compute the non parametric component functions.}

\item{plot}{a logical value to return plots. Default value is \code{TRUE}.}

\item{level}{Confidence level.}

\item{...}{other arguments.}
}
\value{
Return a list of all non parametric component functions with their confidence intervals. If \code{plot=TRUE}, the estimated nonparametric component functions are plotted.
}
\description{
Compute and plot the estimated mean and confidence intervals of the non-parametric component of a `APLMS` object fited by `aplms()`.
}
\examples{
data(temperature)
temperature.df = data.frame(temperature,time=1:length(temperature))
model<-aplms::aplms(temperature ~ 1,
                   npc=c("time"), basis=c("cr"),Knot=c(60),
                   data=temperature.df,family=Powerexp(k=0.3),p=1,
                   control = list(tol = 0.001,
                                  algorithm1 = c("P-GAM"),
                                  algorithm2 = c("BFGS"),
                                  Maxiter1 = 20,
                                  Maxiter2 = 25),
                   lam=c(10))
plot(model)
}
\keyword{Additive}
\keyword{Residuals}
\keyword{errors}
\keyword{linear}
\keyword{partial}
\keyword{symmetric}
\keyword{with}
\keyword{xs}
