% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc_helpers.R
\name{anova_latin}
\alias{anova_latin}
\title{Latin Square Design ANOVA}
\usage{
anova_latin(
  data,
  response,
  treatment,
  row,
  column,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{response}{Name of the response variable}

\item{treatment}{Name of treatment factor}

\item{row}{Name of row factor}

\item{column}{Name of column factor}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results
}
\description{
Performs ANOVA for Latin Square Design with row and column blocking.
}
\examples{
# 5x5 Latin Square
data <- data.frame(
  row = rep(1:5, each = 5),
  col = rep(1:5, 5),
  treatment = c("A","B","C","D","E", "B","C","D","E","A",
                "C","D","E","A","B", "D","E","A","B","C",
                "E","A","B","C","D"),
  yield = rnorm(25, 1200, 100)
)
anova_latin(data, response = "yield", treatment = "treatment",
            row = "row", column = "col")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
