% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_additional.R
\name{anova_strip}
\alias{anova_strip}
\title{============================================================================
ADDITIONAL EXPERIMENTAL DESIGN FUNCTIONS
Package: aridagri
Authors: Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
============================================================================
Strip Plot Design ANOVA}
\usage{
anova_strip(
  data,
  response,
  horizontal_factor,
  vertical_factor,
  replication,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{horizontal_factor}{Factor applied in horizontal strips (A)}

\item{vertical_factor}{Factor applied in vertical strips (B)}

\item{replication}{Name of replication factor}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results
}
\description{
Performs ANOVA for Strip Plot (Strip-Split) Design where two factors
are applied in horizontal and vertical strips.
}
\examples{
data <- expand.grid(
  rep = 1:4,
  irrigation = c("I1", "I2", "I3"),
  tillage = c("CT", "MT", "ZT")
)
data$yield <- rnorm(nrow(data), 1200, 150)
anova_strip(data, response = "yield", horizontal_factor = "irrigation",
            vertical_factor = "tillage", replication = "rep")

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
