% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{extract_sample_depths}
\alias{extract_sample_depths}
\title{Extract unnested samples with stratigraphic depths}
\usage{
extract_sample_depths(
  strat_data,
  sample_column = "SampleID",
  remove_layer_metadata = FALSE
)
}
\arguments{
\item{strat_data}{A data frame ready for applying \code{\link[=add_depths]{add_depths()}},
containing \code{"SampleID"} or another column you want to expand to
sample-level rows.}

\item{sample_column}{A string giving the name of the column to extract
and unnest. Defaults to \code{"SampleID"}.}

\item{remove_layer_metadata}{Logical. If \code{TRUE}, only the selected
sample column and the depth columns (\code{Depth_top}, \code{Depth_middle},
\code{Depth_bottom}) are returned. Defaults to \code{FALSE}.}
}
\value{
A data frame with one row per sample, including the depth
information and associated layer metadata (unless
\code{remove_layer_metadata = TRUE}).
}
\description{
\code{extract_sample_depths()} takes a stratigraphic dataset that has already been merged
(e.g. from \code{\link[=load_geodiva_forms]{load_geodiva_forms()}} or \code{\link[=load_stratdata_indiv]{load_stratdata_indiv()}}) and
applies \code{\link[=add_depths]{add_depths()}} to compute absolute depths. It then expands a
nested sample column (by default \code{"SampleID"}) so that each sample is
represented as its own row, and drops rows where the chosen column is
missing. Optionally, you can strip away all other layer metadata and
return only the sample IDs and depth columns. Can be used on any nested or
unested column.
}
\examples{
# Default: expand the SampleID column
extract_sample_depths(example_data_strat)

# Expand a different column (here "stratlayer_sample")
extract_sample_depths(example_data_strat, sample_column = "stratlayer_sample")

# Return only SampleID and depth columns
extract_sample_depths(example_data_strat, remove_layer_metadata = TRUE)
}
