% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_client_vpn_route}
\alias{ec2_create_client_vpn_route}
\title{Create Client Vpn Route}
\usage{
ec2_create_client_vpn_route(
  ClientVpnEndpointId,
  DestinationCidrBlock,
  TargetVpcSubnetId,
  Description = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ClientVpnEndpointId}{Character. The ID of the Client VPN endpoint to which to add the route.}

\item{DestinationCidrBlock}{Character.   The IPv4 address range, in CIDR notation, of the route destination.}

\item{TargetVpcSubnetId}{Character.   The ID of the subnet through which you want to route traffic.}

\item{Description}{Character. A brief description of the route.[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Adds a route to a network to a Client
VPN endpoint. Each Client VPN endpoint has a route table that describes
the available destination network routes. Each route in the route table
specifies the path for tra_c to speci_c resources or
networks.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint to which to add the route.
}

\section{DestinationCidrBlock}{


The IPv4 address range, in CIDR notation, of the route destination. For
example:
\itemize{
\item To add a route for Internet access, enter \verb{0.0.0.0/0}
\item To add a route for a peered VPC, enter the peered VPC\'s IPv4 CIDR
range
\item To add a route for an on-premises network, enter the AWS
Site-to-Site VPN connection\'s IPv4 CIDR range
\item To add a route for the local network, enter the client CIDR range
}
}

\section{TargetVpcSubnetId}{


The ID of the subnet through which you want to route traffic. The
specified subnet must be an existing target network of the Client VPN
endpoint.

Alternatively, if you\'re adding a route for the local network, specify
\code{local}.
}

\section{Description}{

A brief description of the
route.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to Ensure Idempotency}.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

