% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.R
\name{funnel_plot}
\alias{funnel_plot}
\title{Funnel plots for baggr models}
\usage{
funnel_plot(
  bg,
  show = c("inputs", "posterior"),
  level = 0.95,
  label = FALSE,
  covariate = NULL
)
}
\arguments{
\item{bg}{a \code{\link[=baggr]{baggr()}} model}

\item{show}{whether to plot raw study-level inputs (\code{"inputs"}) or
posterior summaries (\code{"posterior"})}

\item{level}{confidence level for reference lines}

\item{label}{logical: add study/group labels?}

\item{covariate}{optional name of a column in the model input data used to
colour points.}
}
\value{
A ggplot funnel plot for the supplied model
}
\description{
Funnel plots for baggr models
}
\details{
Funnel plots provide a visual check of how study-level effects vary with
precision. Apparent asymmetry can indicate small-study effects, but can also
arise due to unexplained heterogeneity between studies.

For models with group-level covariates, colouring points by a covariate can
help inspect whether asymmetry is partly explained by meta-regression effects.
}
\examples{
bg <- baggr(schools, iter = 500, refresh = 0)
funnel_plot(bg, label = TRUE)

}
