% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{beta_parms_from_quantiles}
\alias{beta_parms_from_quantiles}
\title{Pick parameters in the Beta distribution to match the specified range}
\usage{
beta_parms_from_quantiles(
  q,
  p = c(0.025, 0.975),
  precision = 0.001,
  derivative.epsilon = 0.001,
  start.with.normal.approx = TRUE,
  start = c(1, 1),
  plot = FALSE
)
}
\arguments{
\item{q}{A vector of lower and upper bounds, in which Beta distribution
will have quantiles specified by \code{p}. For example, \code{q=c(0.5,0.99)}}

\item{p}{The lower and upper quantiles of the range one wants to specify.}

\item{precision}{Approximation precisions.}

\item{derivative.epsilon}{Precision of calculating derivative.}

\item{start.with.normal.approx}{Default is \code{TRUE}, for normal approximation.}

\item{start}{Starting values of beta parameters.}

\item{plot}{Default is \code{FALSE} to suppress plotting of the beta density,
otherwise, set to \code{TRUE}.}
}
\value{
A list containing the selected Beta parameters \code{a}, and \code{b}.
Other elements of the list include some details about the computations involved
in finding \code{a} and \code{b}.
}
\description{
\code{beta_parms_from_quantiles} produces prior Beta parameters for
the true positive rates (TPR)
}
\examples{

beta_parms_from_quantiles(c(0.5,0.99))

}
