% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_posterior_unified.R
\name{extract_posterior_unified}
\alias{extract_posterior_unified}
\title{Extract Posterior Draws (Unified Interface)}
\usage{
extract_posterior_unified(
  model,
  parameters = NULL,
  format = c("draws_df", "draws_matrix", "draws_array", "list"),
  n_draws = NULL,
  include_warmup = FALSE,
  chains = NULL,
  ...
)
}
\arguments{
\item{model}{A fitted Bayesian model object}

\item{parameters}{Character vector of parameter names to extract (default: all)}

\item{format}{Output format: "draws_df", "draws_matrix", "draws_array", or "list"}

\item{n_draws}{Number of draws to extract (default: all available)}

\item{include_warmup}{Logical. Include warmup/burn-in draws (default: FALSE)}

\item{chains}{Numeric vector of chain IDs to extract (default: all chains)}

\item{...}{Additional arguments for specific model types}
}
\value{
Posterior draws in the requested format:
\itemize{
\item \strong{draws_df}: Data frame with one row per draw
\item \strong{draws_matrix}: Matrix with draws in rows, parameters in columns
\item \strong{draws_array}: 3D array (iterations x chains x parameters)
\item \strong{list}: Named list of parameter vectors
}
}
\description{
Provides a unified interface for extracting posterior draws from multiple
Bayesian modeling packages (brms, rstanarm, cmdstanr, etc.).
}
\details{
This function provides a consistent interface across different Bayesian
modeling packages, handling their different internal formats automatically.

Supported model types:
\itemize{
\item \code{brmsfit} (brms)
\item \code{stanfit} (rstan)
\item \code{stanreg} (rstanarm)
\item \code{CmdStanMCMC} (cmdstanr)
\item \code{mcmc.list} (coda)
}
}
\examples{
\donttest{
library(brms)
fit <- brm(mpg ~ hp + wt, data = mtcars)

# Extract as data frame
draws_df <- extract_posterior_unified(fit, format = "draws_df")

# Extract specific parameters
slopes <- extract_posterior_unified(
  fit,
  parameters = c("b_hp", "b_wt"),
  format = "draws_matrix"
)

# Extract first 1000 draws from chain 1
subset_draws <- extract_posterior_unified(
  fit,
  n_draws = 1000,
  chains = 1
)
}

}
