% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comparison_suite.R
\name{model_comparison_suite}
\alias{model_comparison_suite}
\title{Comprehensive Model Comparison Suite}
\usage{
model_comparison_suite(..., criterion = "loo", plot = TRUE, detailed = TRUE)
}
\arguments{
\item{...}{Multiple brmsfit objects to compare}

\item{criterion}{Character vector of criteria to use.
Options: "loo" (default), "waic", "bayes_r2", "all"}

\item{plot}{Logical. Generate comparison plots? (default: TRUE)}

\item{detailed}{Logical. Return detailed statistics? (default: TRUE)}
}
\value{
A list of class \code{model_comparison} containing:
\item{comparison_table}{Data frame with model rankings and IC values}
\item{ic_differences}{Data frame with IC differences and weights}
\item{model_names}{Character vector of model names}
\item{plots}{List of ggplot objects (if plot = TRUE)}
\item{criterion_used}{Character vector of criteria used}
}
\description{
Compares multiple Bayesian models using information criteria (LOO, WAIC, Bayes R2)
and generates comparison tables with rankings and visualizations.
}
