% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credint.R
\name{credint}
\alias{credint}
\alias{credint.lm_b}
\alias{credint.aov_b}
\alias{credint.glm_b}
\alias{credint.np_glm_b}
\alias{credint.lm_b_bma}
\title{Credible Intervals for Model Parameters}
\usage{
credint(object, ...)

\method{credint}{lm_b}(object, CI_level = 0.95, ...)

\method{credint}{aov_b}(object, CI_level = 0.95, which = "means", ...)

\method{credint}{glm_b}(object, CI_level = 0.95, ...)

\method{credint}{np_glm_b}(object, CI_level = 0.95, ...)

\method{credint}{lm_b_bma}(object, CI_level = 0.95, ...)
}
\arguments{
\item{object}{a fitted model object from \code{bayesics}}

\item{...}{Passed to methods.}

\item{CI_level}{the credible level required}

\item{which}{character.  For \code{aov_b} only. Either "means" (for the
group means) or "pairwise" (for pairwise difference in means).}
}
\value{
Matrix of credible intervals
}
\description{
Computes credible intervals for one or more parameters in a
fitted model.
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rep(letters[1:5],N/5))
test_data$outcome = 
  rnorm(N,-1 + 2 * (test_data$x1 \%in\% c("d","e")) )

# Fit 1-way ANOVA model
fit1 <-
  aov_b(outcome ~ x1,
        test_data,
        prior_mean_mu = 2,
        prior_mean_nu = 0.5,
        prior_var_shape = 0.01,
        prior_var_rate = 0.01)
credint(fit1)
}


}
