% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_b.R
\name{t_test_b}
\alias{t_test_b}
\title{t-test}
\usage{
t_test_b(
  x,
  y,
  mu,
  paired = FALSE,
  data,
  heteroscedastic = TRUE,
  prior_mean_mu,
  prior_mean_nu = 0.001,
  prior_var_shape = 0.001,
  prior_var_rate = 0.001,
  CI_level = 0.95,
  ROPE = 0.1,
  improper = FALSE,
  plot = TRUE,
  seed = 1,
  mc_error = 0.002
)
}
\arguments{
\item{x}{Either a (non-empty) numeric vector of data values, or a formula
of the form outcome ~ grouping variable.}

\item{y}{an optional (non-empty) numeric vector of data values}

\item{mu}{optional.  If supplied, \code{t_test_b} will return the
posterior probabilty that the population mean (ignored in 2 sample inference)
is less than this value.}

\item{paired}{logical.  If TRUE, provide both x and y as vectors.}

\item{data}{logical.  Only used if x is a formula.}

\item{heteroscedastic}{logical.  Set to FALSE to assume all groups have
equal variance.}

\item{prior_mean_mu}{numeric. Hyperparameter for the a priori mean of the
group means.}

\item{prior_mean_nu}{numeric. Hyperparameter which scales the precision of
the group means.}

\item{prior_var_shape}{numeric. Twice the shape parameter for the inverse gamma prior on
the residual variance(s).  I.e., \eqn{\sigma^2\sim IG}(prior_var_shape/2,prior_var_rate/2).}

\item{prior_var_rate}{numeric. Twice the rate parameter for the inverse gamma prior on
the residual variance(s).  I.e., \eqn{\sigma^2\sim IG}(prior_var_shape/2,prior_var_rate/2).}

\item{CI_level}{numeric. Credible interval level.}

\item{ROPE}{numeric.  Used to compute posterior probability that Cohen's D +/- ROPE}

\item{improper}{logical.  Should we use an improper prior that is proportional
to the inverse of the variance?}

\item{plot}{logical. Should the resulting inverse gamma distribution be plotted?}

\item{seed}{integer.  Always set your seed!!!}

\item{mc_error}{The number of posterior draws will ensure that with 99\%
probability the bounds of the credible intervals will be within \eqn{\pm}
\code{mc_error}\eqn{\times 4s_y}, that is, within 100\code{mc_error}\% of the
trimmed range of y. (Ignored for single population inference.)}
}
\value{
Either an aov_b object, if two samples are being compared,
or a list with the following elements:
\itemize{
\item Variable
\item Post Mean
\item Lower (bound of credible interval)
\item Upper (bound of credible interval)
\item Prob Dir (Probability of Direction)
}
}
\description{
One and two sample t-tests on vectors of data
}
\details{
A one and two sample t-test is nothing more than a special case of
one-way anova.  See \code{\link{aov_b}} for details.
}
\examples{
\donttest{
# Single population
t_test_b(rnorm(50))
# or an alternative input format
t_test_b(outcome ~ 1,
         data = data.frame(outcome = rnorm(50)))

# Two populations
t_test_b(rnorm(50),
         rnorm(15,1))

# or an alternative input format
t_test_b(outcome ~ group_variable,
         data = 
           data.frame(outcome = c(rnorm(50),
                                  rnorm(15,1)),
                      group_variable = rep(c("a","b"),
                                           c(50,15))))
}


}
