% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{predict.brsmm}
\alias{predict.brsmm}
\title{Predict from a brsmm model}
\usage{
\method{predict}{brsmm}(
  object,
  newdata = NULL,
  type = c("response", "link", "precision", "variance", "quantile"),
  at = 0.5,
  ...
)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{newdata}{Optional data frame.}

\item{type}{Character: \code{"response"} (default), \code{"link"},
\code{"precision"}, \code{"variance"}, or \code{"quantile"}.}

\item{at}{Numeric vector of probabilities for quantile
predictions (default 0.5).}

\item{...}{Currently ignored.}
}
\value{
Numeric vector.
}
\description{
Predict from a brsmm model
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
head(predict(fit))
head(predict(fit, type = "precision"))
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{fitted.brsmm}},
  \code{\link{brs_predict_scoreprob}}
}
